package mcfall.raytracer.objects;

import mcfall.math.Vector;
import mcfall.raytracer.ThreeDimensionalObject;

public class HitRecord implements Comparable {
	
	
	
	public double hitTime;
	public Vector normal;
	public ThreeDimensionalObject object;
	public Object extraInfo;
	
	public HitRecord (double hitTime, Vector normalVector, ThreeDimensionalObject object) {
		this (hitTime, normalVector, object, null);		
	}
	
	public HitRecord (double hitTime, Vector normalVector, ThreeDimensionalObject object, Object extraInfo) {
		this.hitTime = hitTime;
		this.normal = normalVector;
		this.object = object;
		this.extraInfo = extraInfo;
	}
	
	public int compareTo(Object o) {
		HitRecord other = (HitRecord) o;
		Double myTime = new Double(hitTime);
		return myTime.compareTo(other.hitTime);
	}
	
}
